/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.editor.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import rpgboss.editor.StateMaster;
import rpgboss.model.SpriteSpec;
import rpgboss.model.resource.Spriteset;
import rpgboss.model.resource.Spriteset$;
import rpgboss.model.resource.SpritesetMetadata;
import rpgboss.model.resource.Tileset$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u0013\tyQI^3oi&k\u0017mZ3DC\u000eDWM\u0003\u0002\u0004\t\u0005)1-Y2iK*\u0011QAB\u0001\u0007K\u0012LGo\u001c:\u000b\u0003\u001d\tqA\u001d9hE>\u001c8o\u0001\u0001\u0014\u0005\u0001Q\u0001\u0003B\u0006\u0014+mi\u0011\u0001\u0004\u0006\u0003\u00075Q!AD\b\u0002\r\r|W.\\8o\u0015\t\u0001\u0012#\u0001\u0004h_><G.\u001a\u0006\u0002%\u0005\u00191m\\7\n\u0005Qa!aC\"bG\",Gj\\1eKJ\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0004\u0002\u000b5|G-\u001a7\n\u0005i9\"AC*qe&$Xm\u00159fGB\u0011AdI\u0007\u0002;)\u0011adH\u0001\u0006S6\fw-\u001a\u0006\u0003A\u0005\n1!Y<u\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u000f\u0003\u001b\t+hMZ3sK\u0012LU.Y4f\u0011!1\u0003A!A!\u0002\u00139\u0013AA:n!\tA\u0013&D\u0001\u0005\u0013\tQCAA\u0006Ti\u0006$X-T1ti\u0016\u0014\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\b\u0006\u0002/aA\u0011q\u0006A\u0007\u0002\u0005!)ae\u000ba\u0001O!91\u0001\u0001b\u0001\n\u0003\u0011T#A\u001a\u0011\t-!TcG\u0005\u0003k1\u0011A\u0002T8bI&twmQ1dQ\u0016Daa\u000e\u0001!\u0002\u0013\u0019\u0014AB2bG\",\u0007\u0005C\u0003:\u0001\u0011\u0005!(\u0001\u0003m_\u0006$GCA\u000e<\u0011\u0015a\u0004\b1\u0001\u0016\u0003)\u0019\bO]5uKN\u0003Xm\u0019\u0005\u0006}\u0001!\taP\u0001\u0004O\u0016$HCA\u000eA\u0011\u0015\tU\b1\u0001\u0016\u0003\u0005\u0019\b")
public class EventImageCache
extends CacheLoader<SpriteSpec, BufferedImage> {
    private final StateMaster sm;
    private final LoadingCache<SpriteSpec, BufferedImage> cache;

    public LoadingCache<SpriteSpec, BufferedImage> cache() {
        return this.cache;
    }

    @Override
    public BufferedImage load(SpriteSpec spriteSpec) {
        Spriteset spriteset = (Spriteset)Spriteset$.MODULE$.readFromDisk(this.sm.getProj(), spriteSpec.name(), ManifestFactory$.MODULE$.classType(SpritesetMetadata.class));
        BufferedImage srcImg = spriteset.srcTileImg(spriteSpec);
        int dstSz = Tileset$.MODULE$.tilesize() - 4 - 1;
        BufferedImage dstImg = new BufferedImage(dstSz, dstSz, 6);
        Graphics g = dstImg.getGraphics();
        int sx1 = (srcImg.getWidth() - dstSz) / 2;
        int sy1 = 10;
        g.drawImage(srcImg, 0, 0, dstSz - 1, dstSz - 1, sx1, sy1, sx1 + dstSz - 1, sy1 + dstSz - 1, null);
        return dstImg;
    }

    public BufferedImage get(SpriteSpec s2) {
        return this.cache().get(s2);
    }

    public EventImageCache(StateMaster sm) {
        this.sm = sm;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).softValues().maximumSize(50L).expireAfterWrite(10L, TimeUnit.MINUTES).build(this);
    }
}

